#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "global.h"
#include "utils.h"
#include "evolve.h"
#include "agent.h"
#include "field.h"
#include "routine.h"

EVOLUTION_RULE *rules=NULL;
long rules_size=0;
long rules_free=0;


FIELD *current_field_e=NULL;

void init_evolution_rules(void)
{
rules_size=20;
rules_free=0;
rules=do_alloc(rules_size,sizeof(EVOLUTION_RULE));
}

void expand_evolution_rules(void)
{
EVOLUTION_RULE *r;
r=do_alloc(rules_size*2,sizeof(EVOLUTION_RULE));
memcpy(r,rules,rules_free*sizeof(EVOLUTION_RULE));
free(rules);
rules=r;
rules_size=rules_size*2;
}

void generate_evolution_data(void)
{
long i;
for(i=0;i<rules_free;i++){
	rules[i].ac_from=get_agentclass(rules[i].agentclass_from);
	rules[i].ac_to=get_agentclass(rules[i].agentclass_to);
	}
}

void set_current_field(FIELD *f)
{
current_field_e=f;
}

void set_current_agent(long i,long j)
{
if(current_field_e==NULL)return;
current_field_e->current=LOC(i,j);
}

FIELD *get_current_field(void)
{
return current_field_e;
}


int is_applicable(long rule)
{
AGENT *a;
u64 result;
a=get_current_agent();
if(a==NULL)return 0;
if(a->class_handle!=rules[rule].ac_from->class_handle)return 0;
if(execute_routine(rules[rule].condition,&result)<0)return 0;
return result;
}



AGENT *evolve_by_rule(long rule)
{
long i;
AGENT *a,*a1;
a1=get_current_agent();
if(a1==NULL)return NULL;

a=make_agent(rules[rule].ac_to);

/* if evaluation is unsuccessful just copy the value */

for(i=0;i<num_attributes();i++){
	if(execute_routine(rules[rule].evolve[i],&(a->attribute[i]))<0)
		evaluate_attribute(i,&(a->attribute[i]));
	}
return a;

}

AGENT *evolve_agent(AGENT *a_in)
{
long i;
if(a_in==NULL)return NULL;
for(i=0;i<rules_free;i++){
	if(a_in->class_handle==rules[i].ac_from->class_handle){
		if(is_applicable(i)){
			return evolve_by_rule(i);
			}
		}
	} 
return dup_agent(a_in);
}


void evolve(FIELD *f)
{
long i,j;
AGENT ***agent;

agent=do_alloc(f->x_size,sizeof(AGENT ***));
for(i=0;i<f->x_size;i++){
	agent[i]=do_alloc(f->y_size,sizeof(AGENT **));
	}
set_current_field(f);
for(i=0;i<f->x_size;i++)
	for(j=0;j<f->y_size;j++){
		set_current_agent(i,j);
		agent[i][j]=evolve_agent(f->agent[i][j]);
		}


for(i=0;i<f->x_size;i++){
	for(j=0;j<f->y_size;j++)free_agent(f->agent[i][j]);
	free(f->agent[i]);
	}
free(f->agent);
f->agent=agent; 
}

void evolve_fields(void)
{
long i;
for(i=0;i<num_fields();i++){
	evolve(get_field(i));
	}
}


AGENT *get_current_agent(void)
{
FIELD *f;
f=get_current_field();
if(f==NULL)return NULL;
return get_agent(f,LOC(0,0));
}

void dump_rule(FILE *fout,EVOLUTION_RULE *ev)
{
long i;
fprintf(fout,"rule \"%s\" becomes \"%s\"\n",ev->agentclass_from,ev->agentclass_to);
fprintf(fout,"\tcondition \"%s\"\n",ev->condition_name);
for(i=0;i<num_attributes();i++){
	fprintf(fout,"\tattribute \"%s\"\t\"%s\"\n",get_attribute(i)->name,ev->evolve_name[i]);
	}
fprintf(fout,"end\n");
}


void dump_rules(FILE *fout)
{
long i;
for(i=0;i<rules_free;i++)
	dump_rule(fout,&(rules[i]));
}	

EVOLUTION_RULE *add_new_rule(char *from , char *to)
{
EVOLUTION_RULE *r;
long i;
if(rules_free+1>=rules_size)expand_evolution_rules();
r=&(rules[rules_free]);
rules_free++;
r->agentclass_from=strdup(from);
r->agentclass_to=strdup(to);
r->condition_name=strdup("false");
r->ac_from=get_agentclass(from);
r->ac_to=get_agentclass(to);
r->evolve=do_alloc(num_attributes(),sizeof(ROUTINE *));
r->evolve_name=do_alloc(num_attributes(),sizeof(char *));
for(i=0;i<num_attributes();i++){
	r->evolve_name[i]=strdup("unchanged");
	r->evolve[i]=get_routine(get_routine_index(r->evolve_name[i]));
	}
return r;
}

void set_rule_condition(EVOLUTION_RULE *ev, char *cond)
{
ROUTINE *r;
if(ev==NULL)return;
free(ev->condition_name);
ev->condition_name=strdup(cond);
ev->condition=NULL;
r=get_routine(get_routine_index(cond));
if(r==NULL)return;
ev->condition=r;
}

void set_rule_evolve_attr(EVOLUTION_RULE *ev, char *attr_name, char *routine)
{
ROUTINE *r;
long i;
if(ev==NULL)return;
i=get_attribute_index(attr_name);
if(i<0)return;
r=get_routine(get_routine_index(routine));
ev->evolve[i]=NULL;
free(ev->evolve_name[i]);
ev->evolve_name[i]=strdup(routine);
if(r==NULL)return;
ev->evolve[i]=r;
}

int evaluate_attribute(long index, u64 *result)
{
FIELD *f;
AGENT *a;
if(index<0)return -1;
if(index>=num_attributes())return -1;
f=get_current_field();
if(f==NULL)return -1;
a=get_agent(f,LOC(0,0));
if(a==NULL){
	*result=0;
	return -1;
	}
*result=a->attribute[index];
return 0;
}
